@extends('layouts.app')

@section('content')
    <div class="container">

        <br>
        <br>
        <div class="row">
            <div class="panel panel-default">
                <div class="panel-heading">All Services

                </div>

                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-condensed" id="slidersTable">
                            <thead>
                            <tr>
                                <th><span>id.</span></th>
                                <th><span>Service Name</span></th>
                                <th><span>Action</span></th>

                            </tr>
                            </thead>
                            <tbody >

                            @foreach($services as $service)
                                <tr>
                                    <th>{{$service->id}}</th>
                                    <th>{{$service->name}}</th>
                                    <th><a href="{{url('/admin/service/delete/'.$service->id)}}" class="btn btn-danger">Delete</a>
                                        <a href="{{url('/admin/service/edit/'.$service->id)}}" class="btn btn-info">Edit</a></th>
                                </tr>

                            @endforeach
                            </tbody>
                        </table>

                    </div>

                </div>
            </div>
        </div>
    </div>

@endsection
@section('footerscript')
    <script>
        $("#slidersTable").dataTable();
    </script>

@endsection