@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h2>Edit Page</h2>
                {!! Form::open(array('url'=>'admin/pages/edit','class'=>'form', 'files'=> true )) !!}

                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <input type="hidden" name="post_id" value="{{ $page->id }}">
                <div class="form-group">

                    <label for="title">Title</label>

                    <input required="required" value="{{ $page->title }}" placeholder="Enter title here" type="text" name = "title"class="form-control" />

                </div>

                <div class="form-group">

                    <label for="body">Blog Post</label>

                    <textarea name='body'class="form-control" rows="30">{{ $page->content }}</textarea>

                </div>

                <br>

                <input type="submit" name='publish' class="btn btn-success" value = "Publish"/>


                {!! Form::close() !!}

            </div>
        </div>
    </div>
@endsection

@section('footerscript')

    <link rel="stylesheet" href="{{asset('css/token-input-mac.css')}}" type="text/css" />

    <script type="text/javascript" src="{{ asset('/js/tinymce/tinymce.min.js') }}"></script>

    <script type="text/javascript">

        tinymce.init({

            selector : "textarea",

            plugins : ["advlist autolink lists link image charmap print preview anchor", "searchreplace visualblocks code fullscreen", "insertdatetime media table contextmenu paste jbimages"],

            toolbar : "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image jbimages",
            relative_urls : false,
            remove_script_host: false,
            convert_urls: false,
        });

    </script>
@endsection