@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h2>Add New Service</h2>
                {!! Form::open(array('url'=>url('admin/feature/edit/'.$informationfeat->id),'class'=>'form','id'=>'formProduct', 'files'=> true )) !!}
                <input type="hidden" class="token" name="_token" value="{{ csrf_token() }}">

                <div class="form-group">

                    <label >Name</label>

                    <input type="text" name='name' class="form-control"  value="{{$informationfeat->name}}">

                </div>
                <div class="form-group">

                    <label for="body">Content</label>

                    <textarea name='content' class="form-control" rows="20">{{$informationfeat->content}}</textarea>

                </div>

                <div class="form-group">

                    <label>Information Name</label>

                   <select class="form-control" name="information_id">
                       @foreach($informations as $information)
                           @if($information->id == $informationfeat->information->name)
                           <option selected value="{{$information->id}}">{{$information->name}}</option>
                           @else
                               <option value="{{$information->id}}">{{$information->name}}</option>
                           @endif
                           @endforeach
                   </select>

                </div>
                <div class="form-group" >


                    <input type="submit" class="btn btn-primary form-control"/>
                </div>
                {!! Form::close() !!}

            </div>
        </div>
    </div>
@endsection

@section('footerscript')

    <link rel="stylesheet" href="{{asset('css/token-input-mac.css')}}" type="text/css" />

    <script type="text/javascript" src="{{ asset('/js/tinymce/tinymce.min.js') }}"></script>

    <script type="text/javascript">

        tinymce.init({

            selector : "textarea",

            plugins : ["advlist autolink lists link image charmap print preview anchor", "searchreplace visualblocks code fullscreen", "insertdatetime media table contextmenu paste jbimages"],

            toolbar : "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image jbimages",
            relative_urls : false,
            remove_script_host: false,
            convert_urls: false,
        });

    </script>
@endsection