<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('/', "FrontController@index");

Route::get('/about',"FrontController@about");
Route::get('service/immigration','FrontController@immigration');
Route::get('/service/{name}','FrontController@service');

Route::get('/information/{name}','FrontController@information');
Route::get('/home', 'HomeController@index');
Route::get('/news/{slug}','FrontController@news');
Route::get('/page/{slug}','FrontController@pages');
Route::get('/canada/pointcalculator','FrontController@points');
Route::auth();
Route::group(['middleware'=>'auth','prefix'=>'admin'],function() {


    Route::get('/slider/new','AdminController@newsliderview');
    Route::post('/slider/new','AdminController@newslidersave');
    Route::get('/slider/index',"AdminController@getallsliders");
    Route::get('/slider/delete/{id}',"AdminController@deleteslide");


    Route::get('/homepage/about','AdminController@about');
    Route::post('/homepage/about','AdminController@aboutsave');

    Route::get('/stats/new','AdminController@stats');
    Route::post('/stats/new','AdminController@statsave');
    Route::get('/stats/index',"AdminController@statlist");
    Route::get('/stats/delete/{id}',"AdminController@deletestat");

    Route::get('/aboutpage/about','AdminController@aboutpage');
    Route::post('/aboutpage/about','AdminController@aboutpagesave');


    Route::get('/service/new','AdminController@newservice');
    Route::post('/service/new','AdminController@servicesave');
    Route::get('/service/index',"AdminController@servicelist");
    Route::get('/service/delete/{id}',"AdminController@deleteservice");
    Route::get('/service/edit/{id}',"AdminController@editservice");
    Route::post('/service/edit/{id}',"AdminController@updateservice");


    Route::get('/information/new','AdminController@newinformation');
    Route::post('/information/new','AdminController@informationsave');
    Route::get('/information/index',"AdminController@informationlist");
    Route::get('/information/delete/{id}',"AdminController@deleteinformation");
    Route::get('/information/edit/{id}',"AdminController@editinformation");
    Route::post('/information/edit/{id}',"AdminController@updateinformation");



    Route::get('/feature/new','AdminController@newfeature');
    Route::post('/feature/new','AdminController@featuresave');
    Route::get('/feature/index',"AdminController@featurelist");
    Route::get('/feature/delete/{id}',"AdminController@deletefeature");
    Route::get('/feature/edit/{id}',"AdminController@editfeature");
    Route::post('/feature/edit/{id}',"AdminController@updatefeature");

    Route::get('/news/new','AdminController@createnews');
    Route::post('/news/new','AdminController@storenews');
    Route::get('/news/index',"AdminController@newslist");
    Route::get('/news/delete/{id}',"AdminController@destroynews");
    Route::get('/news/edit/{slug}',"AdminController@editnews");
    Route::post('/news/edit',"AdminController@updatenews");

    Route::get('/pages/new','AdminController@createpage');
    Route::post('/pages/new','AdminController@storepage');
    Route::get('/pages/index',"AdminController@pagelist");
    Route::get('/pages/delete/{id}',"AdminController@destroypage");
    Route::get('/pages/edit/{slug}',"AdminController@editpage");
    Route::post('/pages/edit',"AdminController@updatepage");

});
