<?php

namespace App\Http\Controllers;

use App\ExtraPage;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\HomePageAbout;
use App\Slider;
use App\Stats;
use App\Service;
use App\Information;
use App\Page;
use App\News;
class FrontController extends Controller
{
    public function index()
    {
        $sliders = Slider::orderby('created_at','desc')->take(5)->get();
        $about = HomePageAbout::first();
        $stats = Stats::orderby('created_at','asc')->take(4)->get();
        $services = Service::orderby('created_at','asc')->take(6)->get();
        $informations  = Information::orderby('created_at','asc')->take(8)->get();
        $news   = News::orderby('created_at','desc')->take(10)->get();
        return view('index',["sliders"=>$sliders,'about'=>$about,"stats"=>$stats,"services"=>$services,'informations'=>$informations,'newses'=>$news]);
    }

    public function service($name)
    {
        $service  = Service::where('name','=',$name)->first();
        $news   = News::orderby('created_at','desc')->take(10)->get();
        return view('services',["service"=>$service,"newses"=>$news]);
    }


    public function information($name)
    {
        $infomation  = Information::where('name','=',$name)->first();
        $news   = News::orderby('created_at','desc')->take(10)->get();
        return view('information',["information"=>$infomation,"newses"=>$news]);
    }

    public function about()
    {
        $stats = Stats::orderby('created_at','asc')->take(4)->get();
        $about = Page::where('pagename','=','about')->first();
        $news   = News::orderby('created_at','desc')->take(10)->get();
        return view('about',["about"=>$about,"stats"=>$stats,'newses'=>$news]);
    }


    public function immigration()
    {
        $informations  = Information::orderby('created_at','asc')->take(8)->get();
        $newses   = News::orderby('created_at','desc')->take(10)->get();
        return view('immigration',["informations"=>$informations,'newses'=>$newses]);
    }

    public function news($slug)
    {
        $newses   = News::orderby('created_at','desc')->take(10)->get();
        $news  = News::where('slug','=',$slug)->first();
        return view('news',["newses"=>$newses,'news'=>$news]);

    }

    public function pages($slug)
    {

        $newses   = News::orderby('created_at','desc')->take(10)->get();
        $page  = ExtraPage::where('slug','=',$slug)->first();
        return view('pages',["newses"=>$newses,'page'=>$page]);
    }

    public function points()
    { $newses   = News::orderby('created_at','desc')->take(10)->get();
        return view("points",["newses"=>$newses]);
    }
}
