<?php

namespace App\Http\Controllers;

use App\ExtraPage;
use App\Information;
use Illuminate\Http\Request;
use App\Slider;
use App\Http\Requests;
use App\HomePageAbout;
use App\Stats;
use App\Page;
use App\Service;
use App\InformationFeatures;
use App\News;
class AdminController extends Controller
{
    public function newsliderview()
    {
        return view('admin.slider.new');
    }


    public function newslidersave(Request $request)
    {

        if ($request->file('image')->isValid()) {
            $destinationPath = 'uploads/slider'; // upload path
            $extension = $request->file('image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath = $destinationPath . '/' . $fileName;
        } else {

            return "something gone wrong please go back and retry again";
        }
        $slider = new Slider();
        $slider->image_url = $imagepath;
        $slider->save();
        return redirect('home');
    }

    public function getallsliders()
    {
        $sliders = Slider::all();
        return view('admin.slider.index', array("sliders" => $sliders));
    }

    public function deleteslide($id)
    {
        $slider = Slider::find($id);
        $slider->delete();
        return redirect('admin/slider/index');
    }

    public function about()
    {
        $about = HomePageAbout::first();
        if ($about)
            return view('admin.homepage.about', array('about' => $about));
        else {
            $about = new HomePageAbout();
            $about->about = "this is working";
            $about->image_url = "/uploads/exaple.jpg";
            $about->save();
            $about = HomePageAbout::all()->first();
            return view('admin.homepage.about', array('about' => $about));
        }
    }

    public function aboutsave(Request $request)
    {
        if (!empty($request->file('image'))) {
            if ($request->file('image')->isValid()) {
                $destinationPath = 'uploads'; // upload path
                $extension = $request->file('image')->getClientOriginalExtension(); // getting image extension
                $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
                $request->file('image')->move($destinationPath, $fileName); // uploading file to given path
                // sending back with message
                $imagepath = $destinationPath . '/' . $fileName;
            } else {

                return "something gone wrong please go back and retry again";
            }
        }


        $home = HomePageAbout::first();
        $home->about = $request->get('about');
        if (!empty($request->file('image'))) {
            $home->image_url = $imagepath;
        }
        $home->save();
        return redirect('home');
    }


    public function stats()
    {
        return view('admin.stats.stats');
    }

    public function statsave(Request $request)
    {
        $stat = new Stats();
        $stat->figure = $request->get('figure');
        $stat->content = $request->get('content');
        $stat->save();
        return redirect('home');
    }

    public function statlist()
    {
        $stats = Stats::all();
        return view('admin.stats.index', array("stats" => $stats));
    }

    public function deletestat($id)
    {
        $stats = Stats::find($id);
        $stats->delete();
        return redirect('admin/stats/index');
    }

    public function aboutpage()
    {
        $about = Page::where('pagename', 'LIKE', 'about')->get()->first();

        if ($about)
            return view('admin.aboutpage.about', array('about' => $about));
        else {
            $about = new Page();
            $about->pagename = "about";
            $about->image_url = "/uploads/exaple.jpg";
            $about->content = "this is working";
            $about->save();
            $about = Page::where('pagename', 'LIKE', 'about')->get()->first();
            return view('admin.aboutpage.about', array('about' => $about));
        }
    }

    public function aboutpagesave(Request $request)
    {
        if (!empty($request->file('image'))) {
            if ($request->file('image')->isValid()) {
                $destinationPath = 'uploads'; // upload path
                $extension = $request->file('image')->getClientOriginalExtension(); // getting image extension
                $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
                $request->file('image')->move($destinationPath, $fileName); // uploading file to given path
                // sending back with message
                $imagepath = $destinationPath . '/' . $fileName;
            } else {

                return "something gone wrong please go back and retry again";
            }
        }
        $about = Page::where('pagename', '=', 'about')->first();
        $about->pagename = "about";
        if (!empty($request->file('image'))) {
            $about->image_url = $imagepath;
        }
        $about->content = $request->get('content');
        $about->save();

        return redirect('home');

    }


    public function newservice()
    {
        return view('admin.services.new');
    }

    public function servicesave(Request $request)
    {
        if ($request->file('thumb_image')->isValid()) {
            $destinationPath = 'uploads/services'; // upload path
            $extension = $request->file('thumb_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('thumb_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath = $destinationPath . '/' . $fileName;
        } else {

            return "something gone wrong please go back and retry again";
        }
        if ($request->file('page_image')->isValid()) {
            $destinationPath = 'uploads/services'; // upload path
            $extension = $request->file('page_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('page_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath2 = $destinationPath . '/' . $fileName;
        } else {

            return "something gone wrong please go back and retry again";
        }


        $service = new Service();
        $service->name = $request->get('name');
        $service->content = $request->get('content');
        $service->features = $request->get('features');
        $service->thumb_image = $imagepath;
        $service->page_image = $imagepath2;
        $service->save();

        return redirect('home');
    }

    public function servicelist()
    {
        $services = Service::all();
        return view('admin.services.index', ["services" => $services]);
    }

    public function deleteservice($id)
    {
        $service = Service::find($id);
        $service->delete();
        return redirect('admin/service/index');
    }

    public function editservice($id)
    {
        $service = Service::find($id);

        return view('admin.services.edit', ["service" => $service]);
    }

    public function updateservice($id, Request $request)
    {
        if (!empty($request->file('thumb_image')) ? $request->file('thumb_image')->isValid() : false) {
            $destinationPath = 'uploads/services'; // upload path
            $extension = $request->file('thumb_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('thumb_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath = $destinationPath . '/' . $fileName;

        }
        if (!empty($request->file('page_image')) ? $request->file('page_image')->isValid() : false) {
            $destinationPath = 'uploads/services'; // upload path
            $extension = $request->file('page_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('page_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath2 = $destinationPath . '/' . $fileName;
        }
        $service = Service::find($id);
        $service->name = $request->get('name');
        $service->content = $request->get('content');
        $service->features = $request->get('features');


        if (!empty($request->file('thumb_image'))) {
            $service->thumb_image = $imagepath;
        }
        if (!empty($request->file('page_image'))) {
            $service->page_image = $imagepath2;
        }
        $service->save();
        return redirect('admin/service/index');
    }


    public function newinformation()
    {
        return view('admin.informations.new');
    }

    public function informationsave(Request $request)
    {
        if ($request->file('thumb_image')->isValid()) {
            $destinationPath = 'uploads/information'; // upload path
            $extension = $request->file('thumb_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('thumb_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath = $destinationPath . '/' . $fileName;
        } else {

            return "something gone wrong please go back and retry again";
        }
        if ($request->file('page_image')->isValid()) {
            $destinationPath = 'uploads/information'; // upload path
            $extension = $request->file('page_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('page_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath2 = $destinationPath . '/' . $fileName;
        } else {

            return "something gone wrong please go back and retry again";
        }


        $information = new Information();
        $information->name = $request->get('name');
        $information->content = $request->get('content');

        $information->thumb_image = $imagepath;
        $information->page_image = $imagepath2;
        $information->save();

        return redirect('/admin/information/index');
    }

    public function informationlist()
    {
        $informations = Information::all();
        return view('admin.informations.index', ["informations" => $informations]);
    }

    public function deleteinformation($id)
    {
        $information = Information::find($id);
        $information->delete();
        return redirect('admin/information/index');
    }

    public function editinformation($id)
    {
        $information = Information::find($id);
        return view('admin.informations.edit', ["information" => $information]);
    }

    public function updateinformation($id, Request $request)
    {
        if (!empty($request->file('thumb_image')) ? $request->file('thumb_image')->isValid() : false) {
            $destinationPath = 'uploads/information'; // upload path
            $extension = $request->file('thumb_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('thumb_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath = $destinationPath . '/' . $fileName;

        }
        if (!empty($request->file('page_image')) ? $request->file('page_image')->isValid() : false) {
            $destinationPath = 'uploads/information'; // upload path
            $extension = $request->file('page_image')->getClientOriginalExtension(); // getting image extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $request->file('page_image')->move($destinationPath, $fileName); // uploading file to given path
            // sending back with message
            $imagepath2 = $destinationPath . '/' . $fileName;
        }
        $information = Information::find($id);
        $information->name = $request->get('name');
        $information->content = $request->get('content');


        if (!empty($request->file('thumb_image'))) {
            $information->thumb_image = $imagepath;
        }
        if (!empty($request->file('page_image'))) {
            $information->page_image = $imagepath2;
        }
        $information->save();
        return redirect('admin/information/index');
    }


    public function newfeature()
    {
        $informations = Information::all();
        return view('admin.features.new', ["informations" => $informations]);
    }

    public function featuresave(Request $request)
    {


        $informationfeat = new InformationFeatures();
        $informationfeat->name = $request->get('name');
        $informationfeat->content = $request->get('content');
        $informationfeat->information_id = $request->get('information_id');
        $informationfeat->save();

        return redirect('/admin/feature/index');
    }

    public function featurelist()
    {
        $informationfeats = InformationFeatures::all();
        return view('admin.features.index', ["informationfeats" => $informationfeats]);
    }

    public function deletefeature($id)
    {
        $informationfeat = InformationFeatures::find($id);
        $informationfeat->delete();
        return redirect('admin/feature/index');
    }

    public function editfeature($id)
    {
        $informationfeat = InformationFeatures::find($id);
        $informations = Information::all();
        return view('admin.features.edit', ["informationfeat" => $informationfeat, "informations" => $informations]);
    }

    public function updatefeature($id, Request $request)
    {

        $informationfeat = InformationFeatures::find($id);
        $informationfeat->name = $request->get('name');
        $informationfeat->content = $request->get('content');
        $informationfeat->information_id = $request->get('information_id');
        $informationfeat->save();
        return redirect('admin/feature/index');
    }

    public function createnews()
    {
        return view('admin/news/new');
    }

    public function newslist()
    {
        $newses = News::all();
        return view('admin/news/index', ['newses' => $newses]);
    }

    public function storenews(Request $request)
    {
        $post = new News();

        $post->title = $request->get('title');
        $post->body = $request->get('body');
        $post->slug = str_slug($post->title);
        if ($request->has('save')) {
            $post->active = 0;
            $message = 'post saved';
        } else {
            $post->active = 1;
            $message = 'post published';
        }
        $post->save();


        return redirect('/admin/news/index');

    }

    public function editnews($slug)
    {
        $post = News::where('slug', $slug)->first();
        return view('admin.news.edit')->with('news', $post);
    }

    public function updatenews(Request $request)
    {
        //
        $post_id = $request->input('post_id');
        $post = News::find($post_id);

        $title = $request->input('title');
        $slug = str_slug($title);
        $duplicate = News::where('slug', $slug)->first();
        if ($duplicate) {
            if ($duplicate->id != $post_id) {
                return 'you are duplicating slug please  go back and chage title '; //redirect('post/edit/'.$post->slug)->withErrors('Title already exists.')->withInput();
            } else {
                $post->slug = $slug;
            }
        }
        $post->title = $title;
        $post->body = $request->input('body');
        if ($request->has('save')) {
            $post->active = 0;
            $message = 'Post saved successfully';
            $landing = '/admin/news/index';
        } else {
            $post->active = 1;
            $message = 'Post updated successfully';
            $landing = '/admin/news/index';
        }
        $post->save();
        return redirect($landing)->withMessage($message);
    }


    public function destroynews($id)
    {

        $post = News::find($id);
        $post->delete();
        return redirect('/home');
    }




    public function createpage()
    {
        return view('admin/pages/new');
    }

    public function pagelist()
    {
        $newses = ExtraPage::all();
        return view('admin/pages/index', ['pages' => $newses]);
    }

    public function storepage(Request $request)
    {
        $post = new ExtraPage();

        $post->title = $request->get('title');
        $post->content = $request->get('body');
        $post->slug = str_slug($post->title);
         $post->save();


        return redirect('/admin/pages/index');

    }

    public function editpage($slug)
    {
        $post = ExtraPage::where('slug', $slug)->first();
        return view('admin.pages.edit')->with('page', $post);
    }

    public function updatepage(Request $request)
    {

        $post_id = $request->input('post_id');
        $post = ExtraPage::find($post_id);

        $title = $request->input('title');
        $slug = str_slug($title);
        $duplicate = ExtraPage::where('slug', $slug)->first();
        if ($duplicate) {
            if ($duplicate->id != $post_id) {
                return 'you are duplicating slug please  go back and chage title '; //redirect('post/edit/'.$post->slug)->withErrors('Title already exists.')->withInput();
            } else {
                $post->slug = $slug;
            }
        }
        $post->title = $title;
        $post->content = $request->input('body');
       $post->save();
        return redirect('/admin/pages/index');
    }


    public function destroypage($id)
    {

        $post = ExtraPage::find($id);
        $post->delete();
        return redirect('/admin/pages/index');
    }

}
